/*
 * Decompiled with CFR 0.152.
 */
package net.jayjay.dangerzone.entity;

import net.jayjay.dangerzone.block.Block;
import net.jayjay.dangerzone.block.Blocks;
import net.jayjay.dangerzone.client.DZ2;
import net.jayjay.dangerzone.entity.Entity;
import net.jayjay.dangerzone.entity.EntityPlayer;
import net.jayjay.dangerzone.phys.AABB;
import net.jayjay.dangerzone.render.Tesselator;
import net.jayjay.dangerzone.sound.Sound;
import net.jayjay.dangerzone.texture.Textures;
import net.jayjay.dangerzone.world.World;
import org.lwjgl.opengl.GL11;

public class EntityBlock
extends Entity {
    private float xd;
    private float yd;
    private float zd;
    private int tex;
    private int age;
    private int lifetime;
    private int pickupDelay;
    private float size;
    private static int itemCount = 0;
    private static final int MAX_ITEMS = 256;
    private int id;

    public EntityBlock(World level, float x, float y, float z, Block block) {
        super(level);
        if (itemCount >= 256) {
            System.out.println("EntityBlockItem limit reached: " + itemCount + "/" + 256);
            this.remove();
            return;
        }
        ++itemCount;
        this.tex = block.tex;
        if (this.tex < 0) {
            System.out.println("Warning: Invalid texture ID for block " + block.blockTag + ": " + this.tex);
            this.tex = 0;
        }
        this.setSize(0.5f, 0.5f);
        this.heightOffset = this.bbHeight / 2.0f;
        this.setPos(x + 0.5f, y + 0.5f, z + 0.5f);
        this.xd = (float)(Math.random() * 0.2 - 0.1);
        this.yd = 0.2f;
        this.zd = (float)(Math.random() * 0.2 - 0.1);
        this.size = 0.5f;
        this.lifetime = 6000;
        this.pickupDelay = 20;
        this.age = 0;
        this.onGround = false;
        this.id = Blocks.getBlockID(block.blockTag);
    }

    @Override
    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        ++this.age;
        if (this.age >= this.lifetime) {
            this.remove();
            return;
        }
        this.yd -= 0.04f;
        this.move(this.xd, this.yd, this.zd);
        this.xd *= 0.98f;
        this.yd *= 0.98f;
        this.zd *= 0.98f;
        if (this.onGround) {
            this.xd *= 0.7f;
            this.zd *= 0.7f;
            this.yd *= -0.5f;
        }
        if (this.pickupDelay > 0) {
            --this.pickupDelay;
        } else {
            AABB itemBox;
            EntityPlayer player = DZ2.theDangerZone.thePlayer;
            if (player != null && !player.removed && !this.removed && (itemBox = this.getBoundingBox()) != null) {
                itemBox = itemBox.expand(0.5f, 0.5f, 0.5f);
                AABB playerBox = player.getBoundingBox();
                if (playerBox != null && itemBox.intersects(playerBox)) {
                    this.onPlayerPickup(player);
                }
            }
        }
    }

    private void onPlayerPickup(EntityPlayer player) {
        System.out.println("EntityBlockItem picked up by player at " + this.x + ", " + this.y + ", " + this.z);
        DZ2.theDangerZone.ci.inventory[0] = this.id;
        System.out.println(DZ2.theDangerZone.ci.inventory[0]);
        this.remove();
    }

    @Override
    public void setEntityBB(float width, float height) {
        this.bbWidth = width;
        this.bbHeight = height;
        float w = width / 2.0f;
        float h2 = height / 2.0f;
        this.bb = new AABB(this.x - w, this.y - h2, this.z - w, this.x + w, this.y + h2, this.z + w);
    }

    @Override
    public AABB getBoundingBox() {
        return this.bb;
    }

    @Override
    public void render(float partialTicks) {
        Tesselator t = Tesselator.INSTANCE;
        Textures.bindNearest("/terrain.png");
        GL11.glEnable(3553);
        boolean wasLightingEnabled = GL11.glGetBoolean(2896);
        GL11.glDisable(2896);
        t.begin(7);
        t.setColor(1.0f, 1.0f, 1.0f);
        float bob = (float)Math.sin(((float)this.age + partialTicks) * 0.1f) * 0.1f;
        float yOffset = bob * 0.5f;
        this.renderCubed(t, partialTicks, yOffset);
        t.flush();
        if (wasLightingEnabled) {
            GL11.glEnable(2896);
        }
    }

    private void renderCubed(Tesselator t, float partialTicks, float yOffset) {
        float u0 = (float)(this.tex % 16) / 16.0f;
        float u1 = u0 + 0.0624375f;
        float v0 = (float)(this.tex / 16) / 16.0f;
        float v1 = v0 + 0.0624375f;
        float x = this.xo + (this.x - this.xo) * partialTicks;
        float y = this.yo + (this.y - this.yo) * partialTicks + yOffset;
        float z = this.zo + (this.z - this.zo) * partialTicks;
        float r = 0.25f * this.size;
        float x0 = x - r;
        float x1 = x + r;
        float y0 = y - r;
        float y1 = y + r;
        float z0 = z - r;
        float z1 = z + r;
        t.addVertexWithUV(x0, y0, z1, u0, v1);
        t.addVertexWithUV(x0, y0, z0, u0, v0);
        t.addVertexWithUV(x1, y0, z0, u1, v0);
        t.addVertexWithUV(x1, y0, z1, u1, v1);
        t.addVertexWithUV(x1, y1, z1, u1, v1);
        t.addVertexWithUV(x1, y1, z0, u1, v0);
        t.addVertexWithUV(x0, y1, z0, u0, v0);
        t.addVertexWithUV(x0, y1, z1, u0, v1);
        t.addVertexWithUV(x0, y1, z0, u1, v0);
        t.addVertexWithUV(x1, y1, z0, u0, v0);
        t.addVertexWithUV(x1, y0, z0, u0, v1);
        t.addVertexWithUV(x0, y0, z0, u1, v1);
        t.addVertexWithUV(x0, y1, z1, u0, v0);
        t.addVertexWithUV(x0, y0, z1, u0, v1);
        t.addVertexWithUV(x1, y0, z1, u1, v1);
        t.addVertexWithUV(x1, y1, z1, u1, v0);
        t.addVertexWithUV(x0, y1, z1, u1, v0);
        t.addVertexWithUV(x0, y1, z0, u0, v0);
        t.addVertexWithUV(x0, y0, z0, u0, v1);
        t.addVertexWithUV(x0, y0, z1, u1, v1);
        t.addVertexWithUV(x1, y0, z1, u0, v1);
        t.addVertexWithUV(x1, y0, z0, u1, v1);
        t.addVertexWithUV(x1, y1, z0, u1, v0);
        t.addVertexWithUV(x1, y1, z1, u0, v0);
    }

    @Override
    public void remove() {
        this.removed = true;
        Sound.playDZ2Sound("pickup");
        --itemCount;
    }
}

